<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - CRM Sistema</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen flex items-center justify-center p-4">
    
    <div class="w-full max-w-md">
        <!-- Logo/Header -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-blue-600 rounded-xl mb-4">
                <i class="fas fa-chart-line text-white text-2xl"></i>
            </div>
            <h1 class="text-3xl font-bold text-gray-900">CRM Sistema</h1>
            <p class="text-gray-600 mt-2">Acesse sua conta para continuar</p>
        </div>

        <!-- Formulário de Login -->
        <div class="bg-white rounded-2xl shadow-xl p-8" x-data="loginForm()">
            <form @submit.prevent="submitLogin" class="space-y-6">
                <!-- Email -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-envelope mr-2"></i>Email
                    </label>
                    <input 
                        type="email" 
                        id="email" 
                        x-model="form.email"
                        required
                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200"
                        placeholder="seu@email.com"
                        :class="{ 'border-red-500': errors.email }"
                    >
                    <p x-show="errors.email" x-text="errors.email" class="text-red-500 text-sm mt-1"></p>
                </div>

                <!-- Senha -->
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-lock mr-2"></i>Senha
                    </label>
                    <div class="relative">
                        <input 
                            :type="showPassword ? 'text' : 'password'" 
                            id="password" 
                            x-model="form.password"
                            required
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200 pr-12"
                            placeholder="••••••••"
                            :class="{ 'border-red-500': errors.password }"
                        >
                        <button 
                            type="button" 
                            @click="showPassword = !showPassword"
                            class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-gray-600"
                        >
                            <i :class="showPassword ? 'fas fa-eye-slash' : 'fas fa-eye'"></i>
                        </button>
                    </div>
                    <p x-show="errors.password" x-text="errors.password" class="text-red-500 text-sm mt-1"></p>
                </div>

                <!-- Botão de Login -->
                <button 
                    type="submit" 
                    :disabled="loading"
                    class="w-full bg-blue-600 text-white py-3 px-4 rounded-lg font-medium hover:bg-blue-700 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-all duration-200 disabled:opacity-50 disabled:cursor-not-allowed"
                >
                    <span x-show="!loading">
                        <i class="fas fa-sign-in-alt mr-2"></i>Entrar
                    </span>
                    <span x-show="loading" class="flex items-center justify-center">
                        <i class="fas fa-spinner fa-spin mr-2"></i>Entrando...
                    </span>
                </button>

                <!-- Mensagem de Erro -->
                <div x-show="errorMessage" class="bg-red-50 border border-red-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle text-red-500 mr-2"></i>
                        <p x-text="errorMessage" class="text-red-700 text-sm"></p>
                    </div>
                </div>

                <!-- Mensagem de Sucesso -->
                <div x-show="successMessage" class="bg-green-50 border border-green-200 rounded-lg p-4">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <p x-text="successMessage" class="text-green-700 text-sm"></p>
                    </div>
                </div>
            </form>

            <!-- Links Úteis -->
            <div class="mt-6 text-center">
                <p class="text-sm text-gray-600">
                    Problemas para acessar? 
                    <a href="#" class="text-blue-600 hover:text-blue-700 font-medium">Entre em contato</a>
                </p>
            </div>
        </div>

        <!-- Footer -->
        <div class="text-center mt-8 text-sm text-gray-500">
            <p>&copy; 2024 CRM Sistema. Todos os direitos reservados.</p>
        </div>
    </div>

    <script>
        function loginForm() {
            return {
                form: {
                    email: '',
                    password: ''
                },
                errors: {},
                loading: false,
                showPassword: false,
                errorMessage: '',
                successMessage: '',

                async submitLogin() {
                    this.loading = true;
                    this.errors = {};
                    this.errorMessage = '';
                    this.successMessage = '';

                    try {
                        const formData = new FormData();
                        formData.append('action', 'login');
                        formData.append('email', this.form.email);
                        formData.append('password', this.form.password);

                        const response = await fetch('/auth.php', {
                            method: 'POST',
                            body: formData
                        });

                        const result = await response.json();

                        if (result.success) {
                            this.successMessage = 'Login realizado com sucesso! Redirecionando...';
                            
                            // Redirecionar baseado no role
                            setTimeout(() => {
                                if (result.role === 'master') {
                                    window.location.href = '/master.php';
                                } else {
                                    window.location.href = '/dashboard.php';
                                }
                            }, 1500);
                        } else {
                            this.errorMessage = result.message || 'Erro ao fazer login';
                        }
                    } catch (error) {
                        this.errorMessage = 'Erro de conexão. Tente novamente.';
                        console.error('Login error:', error);
                    } finally {
                        this.loading = false;
                    }
                }
            }
        }
    </script>

</body>
</html>
